from llama_index.core import Document, SimpleDirectoryReader
from llama_index.readers.web import BeautifulSoupWebReader
from llama_index.readers.youtube_transcript import YoutubeTranscriptReader

def load_text_contents(text_contents: list[str]):
    """Load multiple text contents as Document objects."""
    return [Document(text=text) for text in text_contents]

def load_files(file_paths):
    """Load documents from local files."""
    if isinstance(file_paths, list):
        reader = SimpleDirectoryReader(input_files=file_paths)
    else:
        reader = SimpleDirectoryReader(input_files=[file_paths])
    return reader.load_data()

def load_websites(urls: list[str]):
    """Load documents from websites."""
    reader = BeautifulSoupWebReader()
    return reader.load_data(urls=urls)

def load_youtube_transcripts(youtube_links: list[str]):
    """Load YouTube transcripts as Document objects."""
    reader = YoutubeTranscriptReader()
    return reader.load_data(ytlinks=youtube_links)
